/* Gallery */
(function (window){
	
	var FWDVUGP = function(props_obj){
		
		var self = this;
	
		/* init gallery */
		this.init = function(){
			
			var test;
			FWDTweenLite.ticker.useRAF(false);
			this.props_obj = props_obj;
			this.listeners = {events_ar:[]};
			
			this.mustHaveHolderDiv_bl = false;
			this.instanceName_str = this.props_obj.instanceName;
			
			if(!self.props_obj.gridType){
				alert("FWDVUGP grid type is required please make sure that the gridType parameter is defined in the contructor function!");
				return;
			}
			
			self.gridType_str = self.props_obj.gridType || "dynamicvertical";
			self.gridType_str = String(self.gridType_str).toLowerCase();
			test = self.gridType_str == "dynamicvertical"
				|| self.gridType_str == "dynamichorizontal"
				|| self.gridType_str == "classicvertical"
				|| self.gridType_str == "classichorizontal"
				|| self.gridType_str == "masonryvertical"
				|| self.gridType_str == "masonryhorizontal"
				|| self.gridType_str == "flexiblevertical"
				|| self.gridType_str == "flexiblehorizontal";
			
			if(!test){
				alert("FWDVUGP grid type value is not valid!");
				return;
			}
			
			if(!this.props_obj.instanceName){
				alert("FWDVUGP instance name is required please make sure that the instanceName parameter exsists and it's value is uinique.");
				return;
			}
			
			if(window[this.instanceName_str]){
				alert("FWDVUGP instance name " + this.instanceName_str +  " is already defined and contains a different instance reference, set a different instance name.");
				return;
			}else{
				window[this.instanceName_str] = this;
			}
		
			if(!this.props_obj){
				alert("FWDVUGP constructor properties object is not defined!");
				return;
			}
			
			if(!this.props_obj.parentId && this.mustHaveHolderDiv_bl){		
				alert("Property parentId is not defined in the FWDVUGP constructor, self property represents the div id into which the megazoom is added as a child!");
				return;
			}
			
			if(this.mustHaveHolderDiv_bl && !FWDVRLUtils.getChildById(self.props_obj.parentId)){
				alert("FWDVUGP parent div is not found, please make sure that the div exsists and the id is correct! " + self.props_obj.parentId);
				return;
			}
			
			this.displayType = this.props_obj.displayType || FWDVUGP.RESPONSIVE;
			this.displayType = this.displayType.toLowerCase();
			
			if(self.displayType.toLowerCase() != FWDVUGP.RESPONSIVE 
			   && self.displayType.toLowerCase() != FWDVUGP.FULL_SCREEN
			   && self.displayType.toLowerCase() != FWDVUGP.FLUID_WIDTH
			   && self.displayType.toLowerCase() != FWDVUGP.AFTER_PARENT){
				this.displayType = FWDVUGP.RESPONSIVE;
			}
		
			this.body = document.getElementsByTagName("body")[0];
			if(this.displayType == FWDVUGP.FULL_SCREEN){
				this.stageContainer = self.body;
			}else{	
				this.stageContainer = FWDVRLUtils.getChildById(this.props_obj.parentId);
			}

			this.customContextMenu;
			this.info_do;
			this.main_do;
			this.preloader_do;
			this.menu_do;
			this.thumbnailManager_do;
			this.lighBox_do;
			this.rect;
			
			this.backgroundColor_str = this.props_obj.backgroundColor || "transparent";
			this.lightBoxBackgroundColor_str = this.props_obj.lightMainBoxBackgroundColor || "transparent";
			
			this.zIndex = parseInt(props_obj.zIndex) || 0;
			this.stageWidth = 0;
			this.stageHeight = 0;
			this.pageXOffset = window.pageXOffset;
			this.pageYOffset = window.pageYOffset;
			this.catId_ar = -1;
			this.maxWidth = this.props_obj.maxWidth || 640;
			this.maxHeight = this.props_obj.maxHeight || 380;
			this.thumbnailsVOffset = this.props_obj.thumbnailsVerticalOffset || 0; 
			
			this.resizeHandlerId1_to;
			this.resizeHandlerId2_to;
			this.scrollEndId_to;
			this.orientationChangeId_to;
			
			this.isVerticalType_bl = true;
			this.isDataLoaded_bl = false;
			this.autoScale_bl = this.props_obj.autoScale == "yes" ? true : false;
			this.showFullScreenButton_bl = this.props_obj.showFullScreenButton == "yes" ? true : false;
			this.orintationChanceComplete_bl = true;
			this.isMobile_bl = FWDVRLUtils.isMobile;
	    	this.hasPointerEvent_bl = FWDVRLUtils.hasPointerEvent;
	    	this.isReady_bl = false;
		
	    	this.setupMainDo();
			this.setupData();	
			this.setupInfo();
		};
		
		//#############################################//
		/* setup main do */
		//#############################################//
		this.setupMainDo = function(){
			this.main_do = new FWDVRLDisplayObject("div", "relative");
			//this.main_do.setOverflow("visible");
			
			this.main_do.getStyle().webkitTapHighlightColor = "rgba(0, 0, 0, 0)";
			this.main_do.getStyle().webkitFocusRingColor = "rgba(0, 0, 0, 0)";
			this.main_do.getStyle().width = "100%";
			this.main_do.getStyle().height = "100%";
			//this.main_do.setBkColor(this.backgroundColor_str);
			if(!FWDVRLUtils.isMobile || (FWDVRLUtils.isMobile && FWDVRLUtils.hasPointerEvent)) this.main_do.setSelectable(false);
			
			if(self.gridType_str == "dynamichorizontal" 
			|| self.gridType_str == "classichorizontal"
			|| self.gridType_str == "masonryhorizontal"
			|| self.gridType_str == "flexiblehorizontal"){
				this.main_do.getStyle().msTouchAction = "none";
				
				if(this.displayType == FWDVUGP.FULL_SCREEN || this.displayType == FWDVUGP.FLUID_WIDTH){	
					this.main_do.getStyle().position = "absolute";
					this.stageContainer.appendChild(this.main_do.screen);
					this.main_do.getStyle().zIndex = self.zIndex;
				}else{
					this.stageContainer.appendChild(this.main_do.screen);
				}		
			}else{
				this.stageContainer.appendChild(this.main_do.screen);
			}
			
			this.stageContainer.style.overflow = "hidden";
			this.startResizeHandler();
		};
		
		//#############################################//
		/* setup info_do */
		//#############################################//
		this.setupInfo = function(){
			FWDVRLInfo.setPrototype();
			this.info_do = new FWDVRLInfo(self, self.data.warningIconPath_str);
		};	
		
		//#############################################//
		/* resize handler */
		//#############################################//
		this.startResizeHandler = function(){
			if(window.addEventListener){
				window.addEventListener("resize", self.onResizeHandler);
				window.addEventListener("scroll", self.onScrollHandler);
			}else if(window.attachEvent){
				window.attachEvent("onresize", self.onResizeHandler);
				window.attachEvent("onscroll", self.onScrollHandler);
			}
			
			
			self.resizeHandler();
			self.resizeHandlerId2_to = setTimeout(function(){
				self.resizeHandler();
				self.positionPreloader();
			}, 400);
		};
		
		this.onResizeHandler = function(e){
			clearTimeout(self.resizeHandlerId2_to);
			self.resizeHandlerId2_to = setTimeout(function(){self.resizeHandler();}, 100);
			//self.resizeHandler();
		};
		
		self.onScrollHandler = function(e){
			self.scrollOffsets = FWDVRLUtils.getScrollOffsets();
			if(self.thumbnailManager_do) FWDVUGP.globalY = self.thumbnailManager_do.getGlobalY();
		};
		
		this.resizeHandler = function(){
			
			self.scrollOffsets = FWDVRLUtils.getScrollOffsets();
			var viewportSize = FWDVRLUtils.getViewportSize();
			var scale;
			var offsetStageHeight = 0;
		
			FWDVUGP.viewportHeight = viewportSize.h;
			
			self.pageXOffset = self.scrollOffsets.x;
			self.pageYOffset = self.scrollOffsets.y;
		
			if(self.gridType_str == "dynamicvertical"
			  || self.gridType_str == "classicvertical"
			  || self.gridType_str == "masonryvertical"
			  || self.gridType_str == "flexiblevertical"
			){
				self.stageWidth = self.stageContainer.offsetWidth;
				
				self.main_do.setWidth(self.stageWidth);
			
				self.globalX = self.main_do.getGlobalX();
				self.globalY = self.main_do.getGlobalY();
				
				clearTimeout(self.resizeGridId_to);
				self.resizeGridId_to =  setTimeout(function(){
		
					if(self.menu_do && self.menu_do.isShowed_bl) self.menu_do.resizeAndPosition(self.stageWidth);
					if(self.thumbnailManager_do){
						self.thumbnailManager_do.resizeAndPosition();
						FWDVUGP.globalY = self.thumbnailManager_do.getGlobalY();
					}
					
					self.setFinalSize();
				}, 100);
			}else if(self.gridType_str == "dynamichorizontal"
					|| self.gridType_str == "classichorizontal"
					|| self.gridType_str == "masonryhorizontal"
					|| self.gridType_str == "flexiblehorizontal"
			){
				if(self.menu_do && self.menu_do.isShowed_bl) self.stageHeight = self.menu_do.h;
					
				if(self.isFullScreen_bl || self.displayType == FWDVUGP.FULL_SCREEN){	
					self.main_do.setX(self.scrollOffsets.x);
					self.main_do.setY(self.scrollOffsets.y);
					self.stageWidth = viewportSize.w;
					self.stageHeight = viewportSize.h;
					self.main_do.setWidth(self.stageWidth);
					self.main_do.setHeight(self.stageHeight);
				}else if(self.displayType == FWDVUGP.FLUID_WIDTH){
					self.stageWidth = viewportSize.w;
					self.stageHeight = viewportSize.h;
					if (self.autoScale_bl){
						scale = Math.min(self.stageWidth/self.maxWidth, 1);
						self.stageHeight = Math.min(parseInt(scale * self.maxHeight), self.maxHeight);
						if(self.stageHeight < 500) self.stageHeight = 500;
						self.stageContainer.style.height = self.stageHeight + "px";
					}else{
						self.stageHeight = self.maxHeight;
						self.stageContainer.style.height = self.stageHeight + "px";
					}
					
					if(self.menu_do){
						if(self.menu_do.isShowed_bl){
							self.menu_do.resizeAndPosition(self.stageWidth);
							offsetStageHeight = self.menu_do.h;
						}else{
							self.menu_do.resizeAndPosition(0);
							offsetStageHeight = 0;
						}
					}
					
					self.main_do.setX(self.pageXOffset);
					self.main_do.setY(Math.round(self.stageContainer.getBoundingClientRect().top + self.pageYOffset));
					
					self.main_do.setWidth(self.stageWidth);
					self.main_do.setHeight(self.stageHeight);
					self.stageContainer.style.height = self.stageHeight + "px";
				}else if(self.displayType == FWDVUGP.RESPONSIVE){
					self.stageContainer.style.width = "100%";
					if(self.stageContainer.offsetWidth > self.maxWidth){
						self.stageContainer.style.width = self.maxWidth + "px";
					}
					self.stageWidth = self.stageContainer.offsetWidth;
					
					if(self.menu_do){
						if(self.menu_do.isShowed_bl){
							self.menu_do.resizeAndPosition(self.stageWidth);
							offsetStageHeight = self.menu_do.h;
						}else{
							self.menu_do.resizeAndPosition(0);
							offsetStageHeight = 0;
						}
					}
					
					if(self.autoScale_bl){
						self.stageHeight = parseInt(self.maxHeight * (self.stageWidth/self.maxWidth)) + self.thumbnailsVOffset * 2;
					}else{
						self.stageHeight = self.maxHeight;
					}
					
					self.main_do.setX(0);
					self.main_do.setY(0);
					
					self.stageHeight += offsetStageHeight;
					
					if(!self.isDataLoaded_bl){
						self.stageHeight = 150;
					}
					
					self.main_do.setWidth(self.stageWidth);
					self.main_do.setHeight(self.stageHeight);
					self.stageContainer.style.height = self.stageHeight + "px";
				
				}else if(self.displayType == FWDVUGP.AFTER_PARENT){
					self.stageWidth = self.stageContainer.offsetWidth;
					self.stageHeight = self.stageContainer.offsetHeight;
					if(self.menu_do){
						if(self.menu_do.isShowed_bl){
							self.menu_do.resizeAndPosition(self.stageWidth);
							offsetStageHeight = self.menu_do.h;
						}else{
							self.menu_do.resizeAndPosition(0);
							offsetStageHeight = 0;
						}
					}
					self.main_do.setWidth(self.stageWidth);
					self.main_do.setHeight(self.stageHeight);
				}else{
					self.main_do.setX(0);
					self.main_do.setY(0);
					self.stageWidth = viewportSize.w;
					self.stageHeight = viewportSize.h;
				}
			}
			
			if(self.menu_do){
				if(self.menu_do.isShowed_bl){
					self.menu_do.resizeAndPosition(self.stageWidth);
				}else{
					self.menu_do.setHeight(0);
				}
			}
			
			if(self.thumbnailManager_do) self.thumbnailManager_do.resizeAndPosition();
			
			if(self.fullScreenButton_do) self.positionFullScreenButton();
		};
		
		this.setFinalSize = function(){
			
			self.stageWidth = self.stageContainer.offsetWidth;
			
			if(!self.isReady_bl){
				self.stageHeight = 84;
				self.main_do.setHeight(self.stageHeight);
			}else{
				self.stageHeight = 0;
			}
			
			if(self.menu_do){
				if(self.menu_do.isShowed_bl){
					self.stageHeight = self.menu_do.h;
				}else{
					self.menu_do.setHeight(0);
				}
			}
				
			if(self.thumbnailManager_do){
				self.stageHeight += self.thumbnailManager_do.totalHeight;
			}
			
			if(self.main_do && self.prevStageHeight != self.stageHeight){
				self.main_do.setWidth(self.stageWidth);
			}
			
			self.prevStageHeight = self.stageHeight;
		};
		
		
		
		//#############################################//
		/* setup context menu */
		//#############################################//
		this.setupContextMenu = function(){
			this.customContextMenu_do = new FWDVRLContextMenu(this.main_do, self.data.rightClickContextMenu_str);
		};
		
		//#############################################//
		/* setup data */
		//#############################################//
		this.setupData = function(){
			FWDVUGPData.setPrototype();
			this.data = new FWDVUGPData(this.props_obj, this);
			this.data.addListener(FWDVUGPData.PRELOADER_LOAD_DONE, this.onPreloaderLoadDone);
			this.data.addListener(FWDVUGPData.LIGHBOX_CLOSE_BUTTON_LOADED, this.onLightBoxCloseButtonLoadDone);
			this.data.addListener(FWDVUGPData.LOAD_ERROR, this.dataLoadError);
			this.data.addListener(FWDVUGPData.LOAD_DONE, this.dataLoadComplete);
		};
		
		this.onLightBoxCloseButtonLoadDone = function(){
			
		};
		
		this.onPreloaderLoadDone = function(){
			self.setupPreloader();
			self.positionPreloader();
			self.resizeHandler();
		};
		
		this.dataLoadError = function(e, text){
			self.main_do.addChild(self.info_do);
			self.info_do.showText(e.text);
		};
		
		this.dataLoadComplete = function(e){
			self.isReady_bl = true;
			self.main_do.getStyle().height = "100%";
			self.catId_ar = self.data.startAtCategory;
			self.setupLightBox();
			//self.updateCategory(self.data.startAtCategory, true);
			if(self.data.showMenu_bl) self.setupMenu();
			self.main_do.addChild(self.preloader_do);
			if(!self.isMobile_bl) self.setupContextMenu();
			self.setupThumbanilsManager();
			if(self.showFullScreenButton_bl) self.setupFullScreenButton();
			
			self.isDataLoaded_bl = true;
			self.resizeHandler();
			self.preloader_do.hide(true);
			setTimeout(self.resizeHandler, 200);
			self.dispatchEvent(FWDVUGP.READY);
		};
		
		//#############################################//
		/* setup preloader */
		//#############################################//
		this.setupPreloader = function(){
			FWDVRLPreloader.setPrototype();
			this.preloader_do = new FWDVRLPreloader(this.data.mainPreloader_img, 38, 38, 30, 36);
			this.preloader_do.addListener(FWDVRLPreloader.HIDE_COMPLETE, this.onPreloaderHideCompleteHandler);
			this.preloader_do.show(true);
			this.main_do.addChild(this.preloader_do);
		};
		
		this.positionPreloader = function(){
			if(this.preloader_do){
				if(self.stageHeight != 0){
					this.preloader_do.setX(parseInt((this.stageWidth - this.preloader_do.w)/2));
					this.preloader_do.setY(parseInt((this.stageHeight - this.preloader_do.h)/2));
				}
			}
		};
		
		this.onPreloaderHideCompleteHandler = function(){
			self.main_do.removeChild(self.preloader_do);
		};
		
		//###########################################//
		/* Setup menu buttons */
		//###########################################//
		this.setupMenu = function(){
			FWDVUGPMenu.setPrototype();
			this.menu_do = new FWDVUGPMenu(self.data, self);
			this.menu_do.addListener(FWDVUGPMenu.MOUSE_UP, this.menuOnMouseUpHandler);
			//this.menu_do.disableCurrentButton(this.catId_ar);
			this.main_do.addChild(this.menu_do);
			this.menu_do.addListener(FWDVUGPMenu.SEARCH, this.searchHandler);
		};
		
		this.menuOnMouseUpHandler =  function(e){
			self.updateCategory(e.id);
		};
		
		this.searchHandler = function(e){
			self.thumbnailManager_do.search(e.searchValue);
		};
		
		//###########################################//
		/* setup thumbs manager */
		//###########################################//
		this.setupThumbanilsManager = function(id){	
			if(self.gridType_str == "dynamicvertical"){
				self.data.isVerticalType_bl = true;
				FWDVUGPVerticalThumbnailsManager.setPrototype();
				this.thumbnailManager_do = new FWDVUGPVerticalThumbnailsManager(this.data, this);
				this.thumbnailManager_do.addListener(FWDVUGPVerticalThumbnailsManager.CATEGORY_UPDATE, this.onTMCategoryUpdate);
				this.thumbnailManager_do.addListener(FWDVUGPVerticalThumbnailsManager.OPEN_LIGHTBOX, this.openLightbox);
			}else if(self.gridType_str == "dynamichorizontal"){
				self.data.isVerticalType_bl = false;
				FWDVUGPHorizontalThumbnailsManager.setPrototype();
				this.thumbnailManager_do = new FWDVUGPHorizontalThumbnailsManager(this.data, this);
				this.thumbnailManager_do.addListener(FWDVUGPHorizontalThumbnailsManager.CATEGORY_UPDATE, this.onTMCategoryUpdate);
				this.thumbnailManager_do.addListener(FWDVUGPHorizontalThumbnailsManager.OPEN_LIGHTBOX, this.openLightbox);
			}else if(self.gridType_str == "classicvertical"){
				self.data.isVerticalType_bl = true;
				FWDVUGPClassicVerticalThumbnailsManager.setPrototype();
				this.thumbnailManager_do = new FWDVUGPClassicVerticalThumbnailsManager(this.data, this);
				this.thumbnailManager_do.addListener(FWDVUGPClassicVerticalThumbnailsManager.CATEGORY_UPDATE, this.onTMCategoryUpdate);
				this.thumbnailManager_do.addListener(FWDVUGPClassicVerticalThumbnailsManager.OPEN_LIGHTBOX, this.openLightbox);
			}else if(self.gridType_str == "classichorizontal"){
				self.data.isVerticalType_bl = false;
				FWDVUGPClassicHorizontalThumbnailsManager.setPrototype();
				this.thumbnailManager_do = new FWDVUGPClassicHorizontalThumbnailsManager(this.data, this);
				this.thumbnailManager_do.addListener(FWDVUGPClassicHorizontalThumbnailsManager.CATEGORY_UPDATE, this.onTMCategoryUpdate);
				this.thumbnailManager_do.addListener(FWDVUGPClassicHorizontalThumbnailsManager.OPEN_LIGHTBOX, this.openLightbox);
			}else if(self.gridType_str == "masonryvertical"){
				self.data.isVerticalType_bl = true;
				FWDVUGPMasonryVerticalThumbnailsManager.setPrototype();
				this.thumbnailManager_do = new FWDVUGPMasonryVerticalThumbnailsManager(this.data, this);
				this.thumbnailManager_do.addListener(FWDVUGPMasonryVerticalThumbnailsManager.CATEGORY_UPDATE, this.onTMCategoryUpdate);
				this.thumbnailManager_do.addListener(FWDVUGPMasonryVerticalThumbnailsManager.OPEN_LIGHTBOX, this.openLightbox);
			}else if(self.gridType_str == "masonryhorizontal"){
				self.data.isVerticalType_bl = false;
				FWDVUGPMasonryHorizontalThumbnailsManager.setPrototype();
				this.thumbnailManager_do = new FWDVUGPMasonryHorizontalThumbnailsManager(this.data, this);
				this.thumbnailManager_do.addListener(FWDVUGPMasonryHorizontalThumbnailsManager.CATEGORY_UPDATE, this.onTMCategoryUpdate);
				this.thumbnailManager_do.addListener(FWDVUGPMasonryHorizontalThumbnailsManager.OPEN_LIGHTBOX, this.openLightbox);
			}else if(self.gridType_str == "flexiblevertical"){
				self.data.isVerticalType_bl = true;
				FWDVUGPFlexibleVerticalThumbnailsManager.setPrototype();
				this.thumbnailManager_do = new FWDVUGPFlexibleVerticalThumbnailsManager(this.data, this);
				this.thumbnailManager_do.addListener(FWDVUGPFlexibleVerticalThumbnailsManager.CATEGORY_UPDATE, this.onTMCategoryUpdate);
				this.thumbnailManager_do.addListener(FWDVUGPFlexibleVerticalThumbnailsManager.OPEN_LIGHTBOX, this.openLightbox);
			}else if(self.gridType_str == "flexiblehorizontal"){
				self.data.isVerticalType_bl = false;
				FWDVUGPFlexibleHorizontalThumbnailsManager.setPrototype();
				this.thumbnailManager_do = new FWDVUGPFlexibleHorizontalThumbnailsManager(this.data, this);
				this.thumbnailManager_do.addListener(FWDVUGPFlexibleHorizontalThumbnailsManager.CATEGORY_UPDATE, this.onTMCategoryUpdate);
				this.thumbnailManager_do.addListener(FWDVUGPFlexibleHorizontalThumbnailsManager.OPEN_LIGHTBOX, this.openLightbox);
			}
			
			
			
			this.main_do.addChild(this.thumbnailManager_do);
			FWDVUGP.globalY = self.thumbnailManager_do.getGlobalY();
			
		};
		
		this.onThumbsManagerLoadError = function(e){
			self.main_do.addChild(self.info_do);
			self.info_do.showText(e.text);
		};
		
		this.onTMCategoryUpdate = function(e){
			//if(self.menu_do) self.menu_do.disableCurrentButton(self.catId_ar);
		};
		
		this.openLightbox = function(e){
			window["rlobj_curObj"] = self.data.lightboxPlaylist_ar;
			FWDVRL.show("rlobj_curObj", e.id);
			window["rlobj_curObj"] = null;
		};
	
		//#######################################//
		/* Setup lightbox */
		//#######################################//
		this.setupLightBox = function(){
			
			new FWDVRL({	
				//main settings
				mainFolderPath:self.data.mainFolderPath_str,
				skinPath:self.data.lightboxSkinPath_str,
				facebookAppId:self.data.facebookAppId_str,
				rightClickContextMenu:self.data.rightClickContextMenu_str,
				buttonsAlignment:self.data.buttonsAlignment_str,
				useDeepLinking:"no",
				useAsModal:self.data.useAsModal_str,
				slideShowAutoPlay:self.data.slideShowAutoPlay_str,
				addKeyboardSupport:self.data.addKeyboardSupport_str,
				showCloseButton:self.data.showCloseButton_str,
				showShareButton:self.data.showShareButton_str,
				showZoomButton:self.data.showZoomButton_str,
				showSlideShowButton:self.data.showSlideShowButton_str,
				showSlideShowAnimation:self.data.showSlideShowAnimation_str,
				showNextAndPrevButtons:self.data.showNextAndPrevButtons_str,
				showNextAndPrevButtonsOnMobile:self.data.showNextAndPrevButtonsOnMobile_str,
				buttonsHideDelay:self.data.buttonsHideDelay,
				slideShowDelay:self.data.slideShowDelay,
				defaultItemWidth:self.data.defaultItemWidth,
				defaultItemHeight:self.data.defaultItemHeight,
				itemOffsetHeight:self.data.itemOffsetHeight,
				spaceBetweenButtons:self.data.spaceBetweenButtons,
				buttonsOffsetIn:self.data.buttonsOffsetIn,
				buttonsOffsetOut:self.data.buttonsOffsetOut,
				itemBorderSize:self.data.itemBorderSize,
				itemBorderRadius:self.data.itemBorderRadius,
				backgroundOpacity:self.data.backgroundOpacity,
				itemBoxShadow:self.data.itemBoxShadow_str,
				itemBackgroundColor:self.data.itemBackgroundColor_str,
				itemBorderColor:self.data.itemBorderColor_str,
				backgroundColor:self.data.lightBoxBackgroundColor_str,
				//thumbnails settings
				showThumbnails:"no",
				showThumbnailsHideOrShowButton:"yes",
				showThumbnailsByDefault:"yes",
				showThumbnailsOverlay:"yes",
				showThumbnailsSmallIcon:"yes",
				thumbnailsHoverEffect:"scale",
				thumbnailsImageHeight:80,
				thumbnailsBorderSize:4,
				thumbnailsBorderRadius:0,
				spaceBetweenThumbnailsAndItem:0,
				thumbnailsOffsetBottom:0,
				spaceBetweenThumbnails:2,
				thumbnailsOverlayOpacity:.6,
				thumbnailsOverlayColor:"#FFFFFF",
				thumbnailsBorderNormalColor:"#FFFFFF",
				thumbnailsBorderSelectedColor:"#FFFFFF",
				//description settings
				showDescriptionButton:self.data.showDescriptionButton_str,
				showDescriptionByDefault:self.data.showDescriptionByDefault_str,
				descriptionWindowAnimationType:self.data.descriptionWindowAnimationType_str,
				descriptionWindowPosition:self.data.descriptionWindowPosition_str,
				descriptionWindowBackgroundColor:self.data.descriptionWindowBackgroundColor_str,
				descriptionWindowBackgroundOpacity:self.data.descriptionWindowBackgroundOpacity,
				//video & audio players settings
				useVideo:"yes",
				useAudio:"yes",
				videoShowFullScreenButton:self.data.videoShowFullScreenButton_str,
				addVideoKeyboardSupport:"yes",
				nextVideoOrAudioAutoPlay:self.data.nextVideoOrAudioAutoPlay_str,
				videoAutoPlay:self.data.videoAutoPlay_str,
				videoLoop:self.data.videoLoop_str,
				audioAutoPlay:self.data.audioAutoPlay_str,
				audioLoop:self.data.audioLoop_str,
				videoControllerHideDelay:3,
				videoControllerHeight:41,
				audioControllerHeight:44,
				startSpaceBetweenButtons:7,
				vdSpaceBetweenButtons:9,
				mainScrubberOffestTop:14,
				scrubbersOffsetWidth:1,
				audioScrubbersOffestTotalWidth:4,
				timeOffsetLeftWidth:5,
				timeOffsetRightWidth:3,
				volumeScrubberWidth:80,
				volumeScrubberOffsetRightWidth:0,
				videoControllerBackgroundColor:self.data.videoControllerBackgroundColor_str,
				videoPosterBackgroundColor:self.data.videoPosterBackgroundColor_str,
				videoPosterBackgroundColor:self.data.videoPosterBackgroundColor_str,
				audioControllerBackgroundColor:self.data.audioControllerBackgroundColor_str,
				timeColor:self.data.timeColor_str
			});
			
			FWDVRL.addListener(FWDVRL.SHOW_START, self.RLShowStart);
			FWDVRL.addListener(FWDVRL.SHOW_COMPLETE, self.RLShowComplete);
			FWDVRL.addListener(FWDVRL.HIDE_START, self.RLHideStart);
			FWDVRL.addListener(FWDVRL.HIDE_COMPLETE, self.RLhideComplete);
		};
		
		
		this.RLShowStart = function(){
			self.dispatchEvent(FWDVUGP.LIGHTBOX_SHOW_START);
		};
		
		this.RLShowComplete = function(){
			self.dispatchEvent(FWDVUGP.LIGHTBOX_SHOW_COMPLETE);
		};
		
		this.RLHideStart = function(){
			self.dispatchEvent(FWDVUGP.LIGHTBOX_HIDE_START);
		};
		
		this.RLhideComplete = function(){
			self.dispatchEvent(FWDVUGP.LIGHTBOX_HIDE_COMPLETE);
		};
	
		//########################################//
		/* Event dispatcher */
		//########################################//
		 this.addListener = function (type, listener){
		    	
		    	if(type == undefined) throw Error("type is required.");
		    	if(typeof type === "object") throw Error("type must be of type String.");
		    	if(typeof listener != "function") throw Error("listener must be of type Function.");
		    	
		    	
		        var event = {};
		        event.type = type;
		        event.listener = listener;
		        event.target = this;
		        this.listeners.events_ar.push(event);
		    };
		    
		    this.dispatchEvent = function(type, props){
		    	if(this.listeners == null) return;
		    	if(type == undefined) throw Error("type is required.");
		    	if(typeof type === "object") throw Error("type must be of type String.");
		    	
		        for (var i=0, len=this.listeners.events_ar.length; i < len; i++){
		        	if(this.listeners.events_ar[i].target === this && this.listeners.events_ar[i].type === type){		
		    	        if(props){
		    	        	for(var prop in props){
		    	        		this.listeners.events_ar[i][prop] = props[prop];
		    	        	}
		    	        }
		        		this.listeners.events_ar[i].listener.call(this, this.listeners.events_ar[i]);
		        	}
		        }
		    };
		    
		   this.removeListener = function(type, listener){
		    	
		    	if(type == undefined) throw Error("type is required.");
		    	if(typeof type === "object") throw Error("type must be of type String.");
		    	if(typeof listener != "function") throw Error("listener must be of type Function." + type);
		    	
		        for (var i=0, len=this.listeners.events_ar.length; i < len; i++){
		        	if(this.listeners.events_ar[i].target === this 
		        			&& this.listeners.events_ar[i].type === type
		        			&& this.listeners.events_ar[i].listener ===  listener
		        	){
		        		this.listeners.events_ar.splice(i,1);
		        		break;
		        	}
		        }  
		    };
		    
		  //##########################################//
			/* Setup fullscreen button */
			//##########################################//
			this.setupFullScreenButton = function(){
				FWDVRLComplexButton.setPrototype();
				self.fullScreenButton_do = new FWDVRLComplexButton(
						self.data.fullScreenN_img, 
						self.data.fullScreenSPath_str, 
						self.data.normalScreenN_img, 
						self.data.normalScreenSPath_str, 
						true);
				
				self.fullScreenButton_do.addListener(FWDVRLComplexButton.MOUSE_UP, self.fullScreenUpHandler);
				self.main_do.addChild(self.fullScreenButton_do);
				
				//self.positionFullScreenButton();
				if(document.addEventListener){
					document.addEventListener("fullscreenchange", self.onFullScreenChange);
					document.addEventListener("mozfullscreenchange", self.onFullScreenChange);
					document.addEventListener("webkitfullscreenchange", self.onFullScreenChange);
				}
			};
			
			this.fullScreenUpHandler = function(e){
				if(self.fullScreenButton_do.currentState == 1){
					
					self.goFullScreen();
				}else{
					
					self.goNormalScreen();
				}
			};
			
			
			this.onFullScreenChange = function(e){
				if(document.fullScreen || document.mozFullScreen || document.webkitIsFullScreen || document.msieFullScreen){
					self.fullScreenButton_do.isFullScreen_bl = true;
					self.isFullScreen_bl = true;
				}else{
					self.fullScreenButton_do.isFullScreen_bl = false;
					self.goNormalScreen();
					self.fullScreenButton_do.setButtonState(1);
				}
			};
			
			this.positionFullScreenButton = function(){
				if(this.showFullScreenButton_bl){
					self.fullScreenButton_do.setX(this.stageWidth - this.fullScreenButton_do.w - 10);
					self.fullScreenButton_do.setY(this.stageHeight - this.fullScreenButton_do.h - 10);
				}else{
					self.fullScreenButton_do.setY(-200);
				}
			};
		    
		    
		  //#############################################//
			/* go fullscreen / normal screen */
			//#############################################//
			this.goFullScreen = function(){
				
				var scrollOffsets = FWDVRLUtils.getScrollOffsets();
				
				self.lastScrollX = scrollOffsets.x;
				self.lastScrollY = scrollOffsets.y;
				
				if (document.documentElement.requestFullScreen) {  
					document.documentElement.requestFullScreen();  
				}else if(document.documentElement.mozRequestFullScreen) {  
					document.documentElement.mozRequestFullScreen();  
				}else if(document.documentElement.webkitRequestFullScreen) {  
					document.documentElement.webkitRequestFullScreen();  
				}else if(document.documentElement.msieRequestFullScreen) {  
					document.documentElement.msieRequestFullScreen();  
				}
				
				self.main_do.getStyle().position = "absolute";
				self.body.style.overflow = "hidden";
				document.documentElement.style.overflow = "hidden";
				document.documentElement.appendChild(self.main_do.screen);
				
				if(self.isMobile_bl)  self.disableMoveOnFullScreen();
				
				self.main_do.getStyle().zIndex = 2147483646;
				
				self.fullScreenButton_do.isFullScreen_bl = true;
				self.fullScreenButton_do.setButtonState(0);
				self.isFullScreen_bl = true;
				
				try{
					this.thumbnailManager_do.deactivateDragScrollBar();
				}catch(e){};
				
				this.resizeHandler();
			};
			
			this.goNormalScreen = function(){		
				if(!self.isFullScreen_bl) return;
				
				if (document.cancelFullScreen) {  
					document.cancelFullScreen();  
				}else if (document.mozCancelFullScreen) {  
					document.mozCancelFullScreen();  
				}else if (document.webkitCancelFullScreen) {  
					document.webkitCancelFullScreen();  
				}else if (document.msieCancelFullScreen) {  
					document.msieCancelFullScreen();  
				}
				
				self.fullScreenButton_do.isFullScreen_bl = false;
				self.fullScreenButton_do.setButtonState(1);
				self.isFullScreen_bl = false;
				if(self.isMobile_bl) self.removeDisableMoveOnFullScreen();
				try{
					this.thumbnailManager_do.deactivateDragScrollBar();
				}catch(e){};
				self.addMainDoToTheOriginalParent();
				self.resizeHandler();
			};
			
			this.addMainDoToTheOriginalParent = function(){
				
				if(FWDVRLUtils.isIE7 && self.displayType == FWDVUGP.FULL_SCREEN){
					document.documentElement.style.overflow = "auto";
					self.body.style.overflow = "auto";
				}else if(self.displayType != FWDVUGP.FULL_SCREEN){
					if(FWDVRLUtils.isIE7){
						document.documentElement.style.overflow = "auto";
						self.body.style.overflow = "visible";
					}else{
						document.documentElement.style.overflow = "visible";
						self.body.style.overflow = "visible";
						//self.body.style.display = "inline";
					}
				}
				
				if(this.displayType == FWDVUGP.FULL_SCREEN){
					if(FWDVRLUtils.isIE7){
						self.body.appendChild(self.main_do.screen);
					}else{
						document.documentElement.appendChild(this.main_do.screen);
					}
				}else if(self.displayType == FWDVUGP.FLUID_WIDTH){
					if(FWDVRLUtils.isIE7){
						self.body.appendChild(self.main_do.screen);
					}else{
						document.documentElement.appendChild(self.main_do.screen);
					}
					self.resizeHandler(true);		
				}else{
					self.main_do.getStyle().position = "relative";
					self.stageContainer.appendChild(self.main_do.screen);
				}
				try{
					this.thumbnailManager_do.deactivateDragScrollBar();
				}catch(e){};
				
				
				self.main_do.getStyle().zIndex = self.zIndex;
				self.main_do.setX(0);
				self.main_do.setY(0);
				self.resizeHandler(true);
				window.scrollTo(self.lastScrollX, self.lastScrollY);
			};
			
			this.disableMoveOnFullScreen = function(e){
				window.addEventListener("touchmove", self.onDisableMove);
			};
			
			this.removeDisableMoveOnFullScreen = function(e){
				window.removeEventListener("touchmove", self.onDisableMove);
			};
			
			this.onDisableMove = function(e){
				e.preventDefault();
			};
		    
		    //###########################################//
		    /* API */
		    //###########################################//
		    this.updateCategory = function(id_ar){
				if(!this.isReady_bl) return;
				
				this.catId_ar = id_ar;
				
				self.thumbnailManager_do.updateCategory(this.catId_ar);
				
				setTimeout(function(){self.dispatchEvent(FWDVUGP.CATEGORY_UPDATE);}, 50);
			};
			
			this.getCategoryName = function(id){
				if(!this.isReady_bl) return;
				return this.data.categories_ar;
			};
			
			this.getCategoryId = function(){
				return this.catId_ar;
			};
			
		    this.updateSize = function(){
		    	if(!self.isReady_bl);
		    	self.resizeHandler();
		    };
		
		this.init();
	};
	
	
	FWDVUGP.READY = "ready";
	FWDVUGP.LIGHTBOX_SHOW_START = "showStart";
	FWDVUGP.LIGHTBOX_SHOW_COMPLETE = "showComplete";
	FWDVUGP.LIGHTBOX_HIDE_START = "hideStart";
	FWDVUGP.LIGHTBOX_HIDE_COMPLETE = "hideComplete";
	FWDVUGP.CATEGORY_UPDATE = "categoryUpdate";
	FWDVUGP.FULL_SCREEN = "fullscreen";
	FWDVUGP.LIGHTBOX = "lightbox";
	FWDVUGP.RESPONSIVE = "responsive";
	FWDVUGP.FLUID_WIDTH = "fluidwidth";
	FWDVUGP.AFTER_PARENT = "afterparent";
	FWDVUGP.IFRAME = "iframe";
	FWDVUGP.IMAGE = "image";
	FWDVUGP.FLASH = "flash";
	FWDVUGP.AUDIO = "audio";
	FWDVUGP.VIDEO = "video";
	FWDVUGP.VIMEO = "vimeo";
	FWDVUGP.YOUTUBE = "youtube";
	FWDVUGP.MAPS = "maps";
	FWDVUGP.LINK = "link";
	FWDVUGP.NONE = "none";
	FWDVIGP = undefined;
	
	
	window.FWDVUGP = FWDVUGP;
	
}(window));